/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryKeyCodec;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.ColumnFuzzedBiomeMagnifier;
import net.minecraft.world.biome.FuzzedBiomeMagnifier;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.biome.provider.NetherBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;

public class DimensionType {
    public static final ResourceLocation field_242710_a = new ResourceLocation("overworld");
    public static final ResourceLocation field_242711_b = new ResourceLocation("the_nether");
    public static final ResourceLocation field_242712_c = new ResourceLocation("the_end");
    public static final Codec<DimensionType> field_235997_a_ = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf("fixed_time").xmap(optional -> optional.map(OptionalLong::of).orElseGet(OptionalLong::empty), optionalLong -> optionalLong.isPresent() ? Optional.of(optionalLong.getAsLong()) : Optional.empty()).forGetter(dimensionType -> dimensionType.field_236010_o_), (App)Codec.BOOL.fieldOf("has_skylight").forGetter(DimensionType::func_218272_d), (App)Codec.BOOL.fieldOf("has_ceiling").forGetter(DimensionType::func_236037_d_), (App)Codec.BOOL.fieldOf("ultrawarm").forGetter(DimensionType::func_236040_e_), (App)Codec.BOOL.fieldOf("natural").forGetter(DimensionType::func_236043_f_), (App)Codec.doubleRange((double)1.0E-5f, (double)3.0E7).fieldOf("coordinate_scale").forGetter(DimensionType::func_242724_f), (App)Codec.BOOL.fieldOf("piglin_safe").forGetter(DimensionType::func_241509_i_), (App)Codec.BOOL.fieldOf("bed_works").forGetter(DimensionType::func_241510_j_), (App)Codec.BOOL.fieldOf("respawn_anchor_works").forGetter(DimensionType::func_241511_k_), (App)Codec.BOOL.fieldOf("has_raids").forGetter(DimensionType::func_241512_l_), (App)Codec.intRange((int)0, (int)256).fieldOf("logical_height").forGetter(DimensionType::func_241513_m_), (App)ResourceLocation.field_240908_a_.fieldOf("infiniburn").forGetter(dimensionType -> dimensionType.field_241504_y_), (App)ResourceLocation.field_240908_a_.fieldOf("effects").orElse((Object)field_242710_a).forGetter(dimensionType -> dimensionType.field_242709_C), (App)Codec.FLOAT.fieldOf("ambient_light").forGetter(dimensionType -> Float.valueOf(dimensionType.field_236017_x_))).apply((Applicative)instance, DimensionType::new));
    public static final float[] field_235998_b_ = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public static final RegistryKey<DimensionType> field_235999_c_ = RegistryKey.func_240903_a_(Registry.field_239698_ad_, new ResourceLocation("overworld"));
    public static final RegistryKey<DimensionType> field_236000_d_ = RegistryKey.func_240903_a_(Registry.field_239698_ad_, new ResourceLocation("the_nether"));
    public static final RegistryKey<DimensionType> field_236001_e_ = RegistryKey.func_240903_a_(Registry.field_239698_ad_, new ResourceLocation("the_end"));
    protected static final DimensionType field_236004_h_ = new DimensionType(OptionalLong.empty(), true, false, false, true, 1.0, false, false, true, false, true, 256, ColumnFuzzedBiomeMagnifier.INSTANCE, BlockTags.field_241277_aC_.func_230234_a_(), field_242710_a, 0.0f);
    protected static final DimensionType field_236005_i_ = new DimensionType(OptionalLong.of(18000L), false, true, true, false, 8.0, false, true, false, true, false, 128, FuzzedBiomeMagnifier.INSTANCE, BlockTags.field_241278_aD_.func_230234_a_(), field_242711_b, 0.1f);
    protected static final DimensionType field_236006_j_ = new DimensionType(OptionalLong.of(6000L), false, false, false, false, 1.0, true, false, false, false, true, 256, FuzzedBiomeMagnifier.INSTANCE, BlockTags.field_241279_aE_.func_230234_a_(), field_242712_c, 0.0f);
    public static final RegistryKey<DimensionType> field_241497_i_ = RegistryKey.func_240903_a_(Registry.field_239698_ad_, new ResourceLocation("overworld_caves"));
    protected static final DimensionType field_241498_j_ = new DimensionType(OptionalLong.empty(), true, true, false, true, 1.0, false, false, true, false, true, 256, ColumnFuzzedBiomeMagnifier.INSTANCE, BlockTags.field_241277_aC_.func_230234_a_(), field_242710_a, 0.0f);
    public static final Codec<Supplier<DimensionType>> field_236002_f_ = RegistryKeyCodec.func_241794_a_(Registry.field_239698_ad_, field_235997_a_);
    private final OptionalLong field_236010_o_;
    private final boolean field_218273_h;
    private final boolean field_236011_q_;
    private final boolean field_236012_r_;
    private final boolean field_236013_s_;
    private final double field_242713_t;
    private final boolean field_236015_u_;
    private final boolean field_241499_s_;
    private final boolean field_241500_t_;
    private final boolean field_241501_u_;
    private final boolean field_241502_v_;
    private final int field_241503_w_;
    private final IBiomeMagnifier field_227175_i_;
    private final ResourceLocation field_241504_y_;
    private final ResourceLocation field_242709_C;
    private final float field_236017_x_;
    private final transient float[] field_236018_y_;

    protected DimensionType(OptionalLong optionalLong, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, ResourceLocation resourceLocation, ResourceLocation resourceLocation2, float f) {
        this(optionalLong, bl, bl2, bl3, bl4, d, false, bl5, bl6, bl7, bl8, n, FuzzedBiomeMagnifier.INSTANCE, resourceLocation, resourceLocation2, f);
    }

    protected DimensionType(OptionalLong optionalLong, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, int n, IBiomeMagnifier iBiomeMagnifier, ResourceLocation resourceLocation, ResourceLocation resourceLocation2, float f) {
        this.field_236010_o_ = optionalLong;
        this.field_218273_h = bl;
        this.field_236011_q_ = bl2;
        this.field_236012_r_ = bl3;
        this.field_236013_s_ = bl4;
        this.field_242713_t = d;
        this.field_236015_u_ = bl5;
        this.field_241499_s_ = bl6;
        this.field_241500_t_ = bl7;
        this.field_241501_u_ = bl8;
        this.field_241502_v_ = bl9;
        this.field_241503_w_ = n;
        this.field_227175_i_ = iBiomeMagnifier;
        this.field_241504_y_ = resourceLocation;
        this.field_242709_C = resourceLocation2;
        this.field_236017_x_ = f;
        this.field_236018_y_ = DimensionType.func_236020_a_(f);
    }

    private static float[] func_236020_a_(float f) {
        float[] fArray = new float[16];
        for (int i = 0; i <= 15; ++i) {
            float f2 = (float)i / 15.0f;
            \u2603 = f2 / (4.0f - 3.0f * f2);
            fArray[i] = MathHelper.func_219799_g(f, \u2603, 1.0f);
        }
        return fArray;
    }

    @Deprecated
    public static DataResult<RegistryKey<World>> func_236025_a_(Dynamic<?> dynamic2) {
        Dynamic<?> dynamic2;
        Optional optional = dynamic2.asNumber().result();
        if (optional.isPresent()) {
            int n = ((Number)optional.get()).intValue();
            if (n == -1) {
                return DataResult.success(World.field_234919_h_);
            }
            if (n == 0) {
                return DataResult.success(World.field_234918_g_);
            }
            if (n == 1) {
                return DataResult.success(World.field_234920_i_);
            }
        }
        return World.field_234917_f_.parse(dynamic2);
    }

    public static DynamicRegistries.Impl func_236027_a_(DynamicRegistries.Impl impl) {
        MutableRegistry<DimensionType> mutableRegistry = impl.func_243612_b(Registry.field_239698_ad_);
        mutableRegistry.func_218381_a(field_235999_c_, field_236004_h_, Lifecycle.stable());
        mutableRegistry.func_218381_a(field_241497_i_, field_241498_j_, Lifecycle.stable());
        mutableRegistry.func_218381_a(field_236000_d_, field_236005_i_, Lifecycle.stable());
        mutableRegistry.func_218381_a(field_236001_e_, field_236006_j_, Lifecycle.stable());
        return impl;
    }

    private static ChunkGenerator func_242717_a(Registry<Biome> registry, Registry<DimensionSettings> registry2, long l) {
        return new NoiseChunkGenerator(new EndBiomeProvider(registry, l), l, () -> registry2.func_243576_d(DimensionSettings.field_242737_f));
    }

    private static ChunkGenerator func_242720_b(Registry<Biome> registry, Registry<DimensionSettings> registry2, long l) {
        return new NoiseChunkGenerator(NetherBiomeProvider.Preset.field_235288_b_.func_242619_a(registry, l), l, () -> registry2.func_243576_d(DimensionSettings.field_242736_e));
    }

    public static SimpleRegistry<Dimension> func_242718_a(Registry<DimensionType> registry, Registry<Biome> registry2, Registry<DimensionSettings> registry3, long l) {
        SimpleRegistry<Dimension> simpleRegistry = new SimpleRegistry<Dimension>(Registry.field_239700_af_, Lifecycle.experimental());
        simpleRegistry.func_218381_a(Dimension.field_236054_c_, new Dimension(() -> registry.func_243576_d(field_236000_d_), DimensionType.func_242720_b(registry2, registry3, l)), Lifecycle.stable());
        simpleRegistry.func_218381_a(Dimension.field_236055_d_, new Dimension(() -> registry.func_243576_d(field_236001_e_), DimensionType.func_242717_a(registry2, registry3, l)), Lifecycle.stable());
        return simpleRegistry;
    }

    public static double func_242715_a(DimensionType dimensionType, DimensionType dimensionType2) {
        double d = dimensionType.func_242724_f();
        \u2603 = dimensionType2.func_242724_f();
        return d / \u2603;
    }

    @Deprecated
    public String func_186067_c() {
        if (this.func_242714_a(field_236006_j_)) {
            return "_end";
        }
        return "";
    }

    public static File func_236031_a_(RegistryKey<World> registryKey, File file) {
        if (registryKey == World.field_234918_g_) {
            return file;
        }
        if (registryKey == World.field_234920_i_) {
            return new File(file, "DIM1");
        }
        if (registryKey == World.field_234919_h_) {
            return new File(file, "DIM-1");
        }
        return new File(file, "dimensions/" + registryKey.func_240901_a_().func_110624_b() + "/" + registryKey.func_240901_a_().func_110623_a());
    }

    public boolean func_218272_d() {
        return this.field_218273_h;
    }

    public boolean func_236037_d_() {
        return this.field_236011_q_;
    }

    public boolean func_236040_e_() {
        return this.field_236012_r_;
    }

    public boolean func_236043_f_() {
        return this.field_236013_s_;
    }

    public double func_242724_f() {
        return this.field_242713_t;
    }

    public boolean func_241509_i_() {
        return this.field_241499_s_;
    }

    public boolean func_241510_j_() {
        return this.field_241500_t_;
    }

    public boolean func_241511_k_() {
        return this.field_241501_u_;
    }

    public boolean func_241512_l_() {
        return this.field_241502_v_;
    }

    public int func_241513_m_() {
        return this.field_241503_w_;
    }

    public boolean func_236046_h_() {
        return this.field_236015_u_;
    }

    public IBiomeMagnifier func_227176_e_() {
        return this.field_227175_i_;
    }

    public boolean func_241514_p_() {
        return this.field_236010_o_.isPresent();
    }

    public float func_236032_b_(long l) {
        double d = MathHelper.func_181162_h((double)this.field_236010_o_.orElse(l) / 24000.0 - 0.25);
        \u2603 = 0.5 - Math.cos(d * Math.PI) / 2.0;
        return (float)(d * 2.0 + \u2603) / 3.0f;
    }

    public int func_236035_c_(long l) {
        return (int)(l / 24000L % 8L + 8L) % 8;
    }

    public float func_236021_a_(int n) {
        return this.field_236018_y_[n];
    }

    public ITag<Block> func_241515_q_() {
        ITag<Block> iTag = BlockTags.func_199896_a().func_199910_a(this.field_241504_y_);
        return iTag != null ? iTag : BlockTags.field_241277_aC_;
    }

    public ResourceLocation func_242725_p() {
        return this.field_242709_C;
    }

    public boolean func_242714_a(DimensionType dimensionType) {
        if (this == dimensionType) {
            return true;
        }
        return this.field_218273_h == dimensionType.field_218273_h && this.field_236011_q_ == dimensionType.field_236011_q_ && this.field_236012_r_ == dimensionType.field_236012_r_ && this.field_236013_s_ == dimensionType.field_236013_s_ && this.field_242713_t == dimensionType.field_242713_t && this.field_236015_u_ == dimensionType.field_236015_u_ && this.field_241499_s_ == dimensionType.field_241499_s_ && this.field_241500_t_ == dimensionType.field_241500_t_ && this.field_241501_u_ == dimensionType.field_241501_u_ && this.field_241502_v_ == dimensionType.field_241502_v_ && this.field_241503_w_ == dimensionType.field_241503_w_ && Float.compare(dimensionType.field_236017_x_, this.field_236017_x_) == 0 && this.field_236010_o_.equals(dimensionType.field_236010_o_) && this.field_227175_i_.equals(dimensionType.field_227175_i_) && this.field_241504_y_.equals(dimensionType.field_241504_y_) && this.field_242709_C.equals(dimensionType.field_242709_C);
    }
}

